<?php

namespace Merchant\Entities;

use Illuminate\Database\Eloquent\Model;

class ContractChange extends Model 
{

    protected $table = 'contract_changes';
    public $timestamps = true;
    protected $fillable = array('contract_id', 'modification_date', 'contract_type', 'experience_renovation', 'renovation_days');
    protected $visible = array('contract_id', 'modification_date', 'contract_type', 'experience_renovation', 'renovation_days');

    public function contract()
    {
        return $this->belongsTo('EmployeeContract', 'contract_id', 'id');
    }

}